/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.picocontainer.Startable;
import org.sonar.api.SonarPlugin;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.plugin.PluginCopier;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginLoader;

public class DefaultPluginRepository
implements Startable {
    private static final Logger LOG = Loggers.get(DefaultPluginRepository.class);
    private final PluginCopier installer;
    private final PluginLoader loader;
    private Map<String, SonarPlugin> pluginInstancesByKeys;
    private Map<String, PluginInfo> infosByKeys;

    public DefaultPluginRepository(PluginCopier installer, PluginLoader loader) {
        this.installer = installer;
        this.loader = loader;
    }

    @Override
    public void start() {
        this.infosByKeys = Maps.newHashMap(this.installer.installRemotes());
        this.pluginInstancesByKeys = Maps.newHashMap(this.loader.load(this.infosByKeys));
        this.logPlugins();
    }

    private void logPlugins() {
        if (this.infosByKeys.isEmpty()) {
            LOG.debug("No plugins loaded");
        } else {
            LOG.debug("Plugins:");
            for (PluginInfo p : this.infosByKeys.values()) {
                LOG.debug("  * {} {} ({})", p.getName(), p.getVersion(), p.getKey());
            }
        }
    }

    @Override
    public void stop() {
        this.loader.unload(this.pluginInstancesByKeys.values());
        this.pluginInstancesByKeys.clear();
        this.infosByKeys.clear();
    }

    public Collection<PluginInfo> getPluginInfos() {
        return this.infosByKeys.values();
    }

    public PluginInfo getPluginInfo(String key) {
        PluginInfo info = this.infosByKeys.get(key);
        Preconditions.checkState(info != null, String.format("Plugin [%s] does not exist", key));
        return info;
    }

    public SonarPlugin getPluginInstance(String key) {
        SonarPlugin instance = this.pluginInstancesByKeys.get(key);
        Preconditions.checkState(instance != null, String.format("Plugin [%s] does not exist", key));
        return instance;
    }

    public boolean hasPlugin(String key) {
        return this.infosByKeys.containsKey(key);
    }
}

